// Using triangular mesh to represent the teapot - compatible with shaders version > 3 drawing by  DrawElements //

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>

#include <GL/glew.h>

#include <GL/glut.h>

#include "geom.h"
#include "shaders.h"

// Shader program and Uniform variable identifiers
GLuint programID;          // shader program
GLuint MVMid,MVPMid,NMid,  // trnasformation matrix uniform IDs 
       NAid,NVid;          // vertex attribute buffer IDs (position * normal) 

// the Main transformation matrices 
GLfloat MM[4][4],   // model matrix (combinations of translations rotations etc.
        VM[4][4],   // view matrix
        MVM[4][4],  // combination of the model and view matrices
        PM[4][4],   // the projection matrix
        MVPM[4][4], // model view and projection matrices combined (the final matrix)
        NM[4][4];   // the matrix that transforms the model's surfac normal vectors 
                    // (this is basically the same as the rotation part of the model 
                    //view matrix  - it is only correct for NON scaled models)

// These are temporary matrices used in assembling the transformations
GLfloat M1[4][4],M2[4][4],M3[4][4],MT[4][4];

// These are the identifiers for the buffers used to 
GLuint vertexbuffer; 
GLuint normalbuffer;
GLuint indexbuffer;

float rotX = 0.0, rotY = 0.0; // user parameter to give the orientation of the teapot (se we can see it from all sides)

#include "model.h"   // model is made of triangular polygon described by a list of verties for each triangle and a list of vertex coorinates. A normal vectgor is generated for each triangle vertex and stires in its own list.

static void Teapot(void){ // calculate the 
 int i,j,k,vi1,vi2,vi3;
 float l,v1[3],v2[3],v3[3],dr1[3],dr2[3],n[3];
 // generate the vertex normals
 for(i=0,k=0;i<num_model_indicies;i++){
   vi1=model_indicies[k++];
   vi2=model_indicies[k++];
   vi3=model_indicies[k++];
   for(j=0;j<3;j++){
     v1[j]=model_vertices[vi1*3+j];
     v2[j]=model_vertices[vi2*3+j];
     v3[j]=model_vertices[vi3*3+j];
   }
   VECSUB(v3,v1,dr1)
   VECSUB(v2,v1,dr2)
   CROSS(dr2,dr1,n)
   l=1.0/LENGTH(n);
   VECSCALE(l,n,n)
   for(j=0;j<3;j++){
     model_vertex_normals[vi1*3+j]=n[j];
     model_vertex_normals[vi2*3+j]=n[j];
     model_vertex_normals[vi3*3+j]=n[j];
   }
 }

 // fill the vertex buffers with the data 
 glGenBuffers(1, &indexbuffer);
 glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, indexbuffer);
 glBufferData(GL_ELEMENT_ARRAY_BUFFER, sizeof(model_indicies), model_indicies, GL_STATIC_DRAW);

 glGenBuffers(1, &vertexbuffer);
 glBindBuffer(GL_ARRAY_BUFFER, vertexbuffer);
 glBufferData(GL_ARRAY_BUFFER, sizeof(model_vertices), model_vertices, GL_STATIC_DRAW);
 glEnableVertexAttribArray(NVid);
 glVertexAttribPointer(NVid,3,GL_FLOAT,GL_FALSE,0, (void*)0   ); // (NVid) must match shader vertex attribute location

 glGenBuffers(1, &normalbuffer);
 glBindBuffer(GL_ARRAY_BUFFER, normalbuffer);
 glBufferData(GL_ARRAY_BUFFER, sizeof(model_vertex_normals), model_vertex_normals, GL_STATIC_DRAW);
 glEnableVertexAttribArray(NAid);
 glVertexAttribPointer(NAid,3,GL_FLOAT,GL_FALSE,0, (void*)0   ); // (NAid) must match the normal attribute location in shader
}

static void Init(void){
  glewExperimental = 1; // for core profile   (GLEW not needed on Mac computer
  if (glewInit() != GLEW_OK) {
   fprintf(stderr, "Failed to initialize GLEW\n");
   return;
  }
  programID = LoadShaders( "simple.vert", "simple.frag" );
  Ident(VM); // looking from (0,0,0) in direction (0,0,-1) the view matrix is just the identity
  MVMid = glGetUniformLocation(programID, "MVM");
  MVPMid = glGetUniformLocation(programID, "MVPM");
  NMid = glGetUniformLocation(programID, "NM");
  NAid=glGetAttribLocation(programID,"glNormal");  
  NVid=glGetAttribLocation(programID,"glVertex");  

  glUseProgram(programID);
  glEnable(GL_DEPTH_TEST);
  glClearColor(0.5, 0.5, 0.5, 1.0);
  glColor3f(1.0, 1.0, 1.0);
  Teapot();
}

static void Reshape(int w, int h){
    glViewport(0, 0, (GLint)w, (GLint)h);
    Ortho(PM, -6.0, 6.0, -6.0, 6.0, -1.0, 10.0);
}

static void Key(unsigned char key, int x, int y){
    switch (key) {
      case 27:   // escape help
      exit(0);
    }
}

static void SpecialKey(int key, int x, int y){
 switch (key) {
      case GLUT_KEY_UP:
 rotX -= 20.0;
 glutPostRedisplay();
 break;
      case GLUT_KEY_DOWN:
 rotX += 20.0;
 glutPostRedisplay();
 break;
      case GLUT_KEY_LEFT:
 rotY -= 20.0;
 glutPostRedisplay();
 break;
      case GLUT_KEY_RIGHT:
 rotY += 20.0;
 glutPostRedisplay();
 break;
 }
}

static void Draw(void){
 glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
 rotx(M1,rotX+270.0);  // 270 matches the Fixed Function rotation
 roty(M2,rotY);
 translate(M3,0.0,0.0,-5.0);
 m4by4(M2,M1,MT);
 m4by4(M3,MT,MM);   // buuld the model matrix 
 m4by4(VM,MM,MVM);  // combinen the model and view matrix 
 m4by4(PM,MVM,MVPM);  // model view and projection matriices combined 

 c4to4(MVM,NM);  NM[0][3]=NM[1][3]=NM[2][3]=NM[3][3]=0.0;    // normal matrix (only using the 3x3 part (assumes no anisotropic scaling)
 transpose4(MVM); // MUST TRANSPOSE BEFORE PASSING TO OpenGL
 glUniformMatrix4fv(MVMid, 1, GL_FALSE, &MVM[0][0]);
 transpose4(MVPM); // MUST TRANSPOSE BEFORE PASSING TO OpenGL
 glUniformMatrix4fv(MVPMid, 1, GL_FALSE, &MVPM[0][0]);
 transpose4(NM);  // MUST TRANSPOSE BEFORE PASSING TO OpenGL
 glUniformMatrix4fv(NMid, 1, GL_FALSE, &NM[0][0]);

 glDrawElements(GL_TRIANGLES,num_model_indicies*3,GL_UNSIGNED_INT,(void*)0);

 glutSwapBuffers();
}


int main(int argc, char **argv){
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);
    glutInitWindowSize(600, 600);
    glutCreateWindow("TeaPot");
    Init();
    glutReshapeFunc(Reshape);
    glutKeyboardFunc(Key);
    glutSpecialFunc(SpecialKey);
    glutDisplayFunc(Draw);
    glutMainLoop();
}
