#version 330 core

// vertex attribute inputs 
layout(location = 0) in vec3 glVertex;  // position
layout(location = 1) in vec3 glNormal;  // normal 

uniform mat4 MVM;   // model view matrix
uniform mat4 MVPM;  // model view projection matrix
uniform mat4 NM;    // normal matrix (only 3x3 is used )

out vec3 normal;    // pass to fragment shader
out vec3 position;  // pass to fragment shader 

void main(){
    position      = (MVM * vec4(glVertex,1)).xyz;
    normal        = (NM * vec4(glNormal,0.0)).xyz;
    // pass the built in variable
    gl_Position   = MVPM * vec4(glVertex,1);
}
