#version 120

varying vec3 normal;
varying vec3 position;

vec3 lightPos=vec3(0.0,0.5,0.0);
vec4 lightColor=vec4(1.0,1.0,1.0,1.0);
vec4 colour=vec4(0.8,0.2,0.2,1.0);

void main() {
 const float Specular=0.9;
 const float Diffuse=0.95;
 float diffuse=0.0,spec=0.0;

 vec3 ldir = normalize(vec3(lightPos-position));
 diffuse = max(dot(ldir,normal), 0.0);
 if(diffuse > 0.0){
   vec3  reflect = reflect(ldir, normalize(normal));
   spec = max(dot(reflect, normalize(position)), 0.0);
   spec = pow(spec, 32.0);
 }
 diffuse=clamp(diffuse,0.0,1.0); 
 spec=clamp(spec,0.0,1.0); 
 gl_FragColor = (colour * (1.0-Diffuse) + colour * Diffuse * diffuse)
              + lightColor* spec * Specular; 
}

// The reflection calculation should really be: (note the -ve signs)
//
// vec3 ldir = normalize(vec3(position-lightPos));  // incident direction
// diffuse = max(dot(-ldir,normal), 0.0);
// if(diffuse > 0.0){
//   vec3  reflect = reflect(ldir, normalize(normal));
//   spec = max(dot(reflect, normalize(-position)), 0.0); // from point to (0,0,0)
//   spec = pow(spec, 32.0);
// }
