#version 120


attribute vec3 glVertex;
attribute vec3 glNormal;

uniform mat4 MVM;   // model view matrix
uniform mat4 MVPM;  // model view projection matrix
uniform mat4 NM;    // normal matrix (only 3x3 is used )

varying vec3 normal;
varying vec3 position;

void main(){
    position      = (MVM * vec4(glVertex,1)).xyz;
    normal        = (NM * vec4(glNormal,0.0)).xyz;
    // pass the built in variable
    gl_Position   = MVPM * vec4(glVertex,1);
}
