#ifndef GEOM_H
#define GEOM_H

void Ident(GLfloat m[4][4]);
void c4to4(GLfloat tin[4][4], GLfloat tout[4][4]);
void m4by4(GLfloat t1[4][4], GLfloat t2[4][4], GLfloat tr[4][4]);
void rotz(float tr[4][4], float ang);
void rotx(float tr[4][4], float ang);
void roty(float tr[4][4], float ang);
void translate(float t[4][4], float dx, float dy, float dz);
void null_transform(float t[4][4]);
void transpose4(GLfloat M[4][4]);
void Ortho(GLfloat m[4][4], GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f );
void Frustum(GLfloat m[4][4], GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f );
void Perspective(GLfloat m[4][4], GLfloat fovy, GLfloat a, GLfloat n, GLfloat f );
void LookAt(GLfloat m[4][4],GLfloat ex,GLfloat ey,GLfloat ez, // eye
                            GLfloat cx,GLfloat cy,GLfloat cz, // target 
                            GLfloat ux,GLfloat uy,GLfloat uz);// up

#define DEGRAD 3.1415926f/180.0f
#define RADDEG 180.0f/3.1415926f
#define VECSCALE(a,b,c) { c[0]=(a)*b[0]; c[1]=(a)*b[1]; c[2]=(a)*b[2];}
#define VECSUB(a,b,c)  { c[0]=a[0]-b[0]; c[1]=a[1]-b[1]; c[2]=a[2]-b[2];}
#define DOT(a,b)        ( (a[0]*b[0]) + (a[1]*b[1]) + (a[2]*b[2]) )
#define CROSS(v1,v2,r)  { \
                          r[0] = (v1[1]*v2[2]) - (v2[1]*v1[2]);  \
                          r[1] = (v1[2]*v2[0]) - (v1[0]*v2[2]);  \
                          r[2] = (v1[0]*v2[1]) - (v2[0]*v1[1]);  \
                        }
#define LENGTH(a)       sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2])
#define LENGTH2(a)      (a[0]*a[0]+a[1]*a[1]+a[2]*a[2])

#endif
