#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glew.h>


#include "shaders.h"


static char VertexShaderCode[9128];
static char FragmentShaderCode[9128];

GLuint LoadShaders(const char * vertex_file_path,const char * fragment_file_path){
 int i;
 FILE *VertexShaderStream;
 FILE *FragmentShaderStream;
 GLint Result = GL_FALSE;
 int InfoLogLength;
 char const *SourcePointer;
 GLuint VertexShaderID;
 GLuint FragmentShaderID;
 GLuint ProgramID;
 for(i=0;i<9128;i++)VertexShaderCode[i]=FragmentShaderCode[i]=0;
 VertexShaderID = glCreateShader(GL_VERTEX_SHADER);
 FragmentShaderID = glCreateShader(GL_FRAGMENT_SHADER);
 // Read the Vertex Shader code from the file
 if((VertexShaderStream=fopen(vertex_file_path,"rb")) != NULL){
  i=0; while(fread(&(VertexShaderCode[i]),1,1,VertexShaderStream) == 1)i++;
 }else{
  printf("Fail to open%s.\n", vertex_file_path);
  return 0;
 }
 fclose(VertexShaderStream);
 // Read the Fragment Shader code from the file
 if((FragmentShaderStream=fopen(fragment_file_path,"rb")) != NULL){
  i=0; while(fread(&(FragmentShaderCode[i]),1,1,FragmentShaderStream) == 1)i++;
 }else{
  printf("Fail to open%s.\n", fragment_file_path);
  return 0;
 }
 fclose(FragmentShaderStream);
 // Compile Vertex Shader
 printf("Compiling shader : %s\n", vertex_file_path);
 SourcePointer = &VertexShaderCode[0];
 glShaderSource(VertexShaderID, 1,&SourcePointer, NULL);
 glCompileShader(VertexShaderID);
 // Check Vertex Shader
 glGetShaderiv(VertexShaderID, GL_COMPILE_STATUS, &Result);
 glGetShaderiv(VertexShaderID, GL_INFO_LOG_LENGTH, &InfoLogLength);
 if ( InfoLogLength > 0 ){
  char VertexShaderErrorMessage[1024];
  printf("Info (v)\n");
  glGetShaderInfoLog(VertexShaderID, InfoLogLength, NULL, &VertexShaderErrorMessage[0]);
  printf("[%s]\n", VertexShaderErrorMessage);
 }
 // Compile Fragment Shader
 printf("Compiling shader : %s\n", fragment_file_path);
 SourcePointer = &FragmentShaderCode[0];
 glShaderSource(FragmentShaderID, 1, &SourcePointer, NULL);
 glCompileShader(FragmentShaderID);
 // Check Fragment Shader
 glGetShaderiv(FragmentShaderID, GL_COMPILE_STATUS, &Result);
 glGetShaderiv(FragmentShaderID, GL_INFO_LOG_LENGTH, &InfoLogLength);
 if ( InfoLogLength > 0 ){
  char FragmentShaderErrorMessage[1024];
  printf("Info (f)\n");
  glGetShaderInfoLog(FragmentShaderID, InfoLogLength, NULL, &FragmentShaderErrorMessage[0]);
  printf("[%s]\n", FragmentShaderErrorMessage);
 }
 // Link the program
 printf("Linking program\n");
 ProgramID = glCreateProgram();
 glAttachShader(ProgramID, VertexShaderID);
 glAttachShader(ProgramID, FragmentShaderID);
 glLinkProgram(ProgramID);
 // Check the program
 glGetProgramiv(ProgramID, GL_LINK_STATUS, &Result);
 glGetProgramiv(ProgramID, GL_INFO_LOG_LENGTH, &InfoLogLength);
 if ( InfoLogLength > 0 ){
  char  ProgramErrorMessage[1024];
  glGetProgramInfoLog(ProgramID, InfoLogLength, NULL, &ProgramErrorMessage[0]);
  printf("%s\n", ProgramErrorMessage);
 }
 glDeleteShader(VertexShaderID);
 glDeleteShader(FragmentShaderID);
 return ProgramID;
}
