#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <GL/glew.h>

#include "geom.h"

void Ident(GLfloat m[4][4]){ int i,j; for(i=0;i<4;i++)for(j=0;j<4;j++)if(i == j)m[i][j]=1.0; else m[i][j]=0.0;}

void c4to4(GLfloat tin[4][4], GLfloat tout[4][4]){int i,j; for(i=0;i<4;i++) for(j=0;j<4;j++) tout[i][j]=tin[i][j];}

void m4by4(GLfloat t1[4][4], GLfloat t2[4][4], GLfloat tr[4][4]){  // tr = t1 X t2
 GLfloat r[4][4];
 long i,j,k; for(i=0;i<4;i++) for(j=0;j<4;j++) { r[i][j]=0.0; for(k=0;k<4;k++)r[i][j]=r[i][j]+t1[i][k]*t2[k][j]; }
 c4to4(r,tr);
}

void rotz(float tr[4][4], float ang){
 long i,j;
 ang *= DEGRAD;
 for(i=0;i<4;i++)
 for(j=0;j<4;j++)
 {
  tr[i][j]=0.0;
  if(i == j)tr[i][j]=1.0;
 }
  tr[0][0] =  cos(ang);
  tr[0][1] = -sin(ang);
  tr[1][0] =  sin(ang);
  tr[1][1] =  cos(ang);
  return;
}

void rotx(float tr[4][4], float ang){
 long i,j;
 ang *= DEGRAD;
 for(i=0;i<4;i++)
 for(j=0;j<4;j++)
 {
  tr[i][j]=0.0;
  if(i == j)tr[i][j]=1.0;
 }
  tr[1][1] =  cos(ang);
  tr[1][2] = -sin(ang);
  tr[2][1] =  sin(ang);
  tr[2][2] =  cos(ang);
  return;
}

void roty(float tr[4][4], float ang){
 long i,j;
 ang *= DEGRAD * (-1.0);   
 for(i=0;i<4;i++)
 for(j=0;j<4;j++)
 {
  tr[i][j]=0.0;
  if(i == j)tr[i][j]=1.0;
 }
  tr[0][0] =  cos(ang);
  tr[0][2] = -sin(ang);
  tr[2][0] =  sin(ang);
  tr[2][2] =  cos(ang);
  return;
}

void translate(float t[4][4], float dx, float dy, float dz){
 long i,j;
 for(i=0;i<4;i++)
 for(j=0;j<4;j++)
 {
  t[i][j]=0.0;
  if(i == j)t[i][j]=1.0;
 }
 t[0][3]=dx;
 t[1][3]=dy;
 t[2][3]=dz;
 t[3][3]=1;
 return;
}

void null_transform(float t[4][4]){
 short i,j;
 for(i=0;i<4;i++)
 for(j=0;j<4;j++)
 if(i == j)t[i][j]=1.0;
 else      t[i][j]=0.0;
}

void transpose4(GLfloat M[4][4]){
 GLfloat O[4][4];
 short i,j;
 for(i=0;i<4;i++)for(j=0;j<4;j++)O[i][j]=M[j][i];
 c4to4(O,M);
}

void Ortho(GLfloat m[4][4], GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f ){
 null_transform(m);
 m[0][0]= 2.0f/(r-l);     m[0][3]= -(r+l)/(r-l);
 m[1][1]= 2.0f/(t-b);     m[1][3]= -(t+b)/(t-b);
 m[2][2]= -2.0f/(f-n);    m[2][3]= -(f+n)/(f-n);
}

void Frustum(GLfloat m[4][4], GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f ){
 null_transform(m);
 m[0][0]= 2.0f*n/(r-l);     m[0][2]= (r+l)/(r-l);
 m[1][1]= 2.0f*n/(t-b);     m[1][2]= (t+b)/(t-b);
 m[2][2]= -(f+n)/(f-n);     m[2][3]= -2.0f*f*n/(f-n);
 m[3][2] = -1;              m[3][3]= 0;
}

void Perspective(GLfloat m[4][4], GLfloat fovy, GLfloat a, GLfloat n, GLfloat f ){
 GLfloat t,b,l,r;
 t = n*(GLfloat)tan(DEGRAD*fovy/2.0); 
 b = -t;
 l = -a*t;
 r =  a*t;
 Frustum(m,l,r,b,t,n,f);
}


void LookAt(GLfloat m[4][4],GLfloat ex,GLfloat ey,GLfloat ez, // eye
                            GLfloat cx,GLfloat cy,GLfloat cz, // target 
                            GLfloat ux,GLfloat uy,GLfloat uz){// up
 // right hand system  f=forward(look) s=rightside u=up
 GLfloat f[3],s[3],u[3],l;
 GLfloat m1[4][4],m2[4][4];
 Ident(m); Ident(m2);
 f[0]=cx-ex; f[1]=cy-ey; f[2]=cz-ez;
 u[0]=ux; u[1]=uy; u[2]=uz;
 l=1.0/LENGTH(f);
 VECSCALE(l,f,f)
 CROSS (f,u,s)
 l=1.0/LENGTH(s);
 VECSCALE(l,s,s)
 CROSS (s,f,u)
 translate(m1,-ex,-ey,-ez);
 null_transform(m2);
 m2[0][0]=  s[0];  m2[0][1]=  s[1]; m2[0][2]=  s[2]; 
 m2[1][0]=  u[0];  m2[1][1]=  u[1]; m2[1][2]=  u[2];        // re-order because Y Z  are reversed with sign change
 m2[2][0]= -f[0];  m2[2][1]= -f[1]; m2[2][2]= -f[2]; 
 // non OpenGL orderings
 m4by4(m2,m1,m);
}


