// File: video.h

// Include file for the components of the code that renders the signal
// from the video camera.

#include <windows.h>
#include <mmsystem.h>
#include <atlbase.h>
#include <stdio.h>
#include <Streams.h>
#include <dshow.h>
#include <commctrl.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include<process.h>
#include<winsock.h>

void Msg(TCHAR *szFormat, ...);


#define BUF_SIZEX 1024      // The OpenGL texture is to be built into a buffer
#define BUF_SIZEY 1024      // of this size, it must be a power of two.


class CVideoCamera {         // This object implements the CAMERA capture thread
public:
    CVideoCamera( );
    ~CVideoCamera();
    HRESULT Render(HWND);
    HRESULT CopyMediaSample( IMediaSample *pSample, LONG lSamplePitch);
    HRESULT SetMediaFormat( GUID subtype);
    HWND    m_hwnd;          // window hande for the OpenGL renderer window
    HRESULT InitDShowRenderer(void);
    GLvoid initializeGL(HWND hWnd);
    void Cleanup(void);
    void ConfigSourceFilter(HWND);

private:
    // methods
    HRESULT CaptureVideo(IBaseFilter *pRenderer);
    HRESULT FindCaptureDevice(IBaseFilter ** ppSrcFilter, long * nfilters);
    void CheckMovieStatus(void);
    void makeMap(unsigned char *, int, int);
    void DrawGeometryWithMask(void);
    void makeCheckeredImageMap(void);
    // data
    CComPtr<ICaptureGraphBuilder2>  m_pCapture;     // Helps to render capture graphs
    CComPtr<IGraphBuilder>          m_pGB;          // GraphBuilder
    CComPtr<IMediaControl>          m_pMC;          // Media Control
    CComPtr<IMediaEvent>            m_pME;          // Media Event
	CComPtr<IAMGraphStreams>		m_pGS;			// graph streams
    CComPtr<IBaseFilter>            m_pSrcFilter;   // Video Source
};
