// File dshowrenderer.h

// Define the class for the custom renderer filter that we use in the FiltgerGraph
// that is rendering the video from the video source.

// The class replicates the CAviRenderer class for a DirectShow Renderer filter except
// that it renders the LIVE camera vidoe stream into a RAM buffer.

struct __declspec(uuid("{7A013080-900F-4c19-918B-5560C2819EFB}")) CLSID_StereoRenderer;

//-----------------------------------------------------------------------------
// CRenderer Class Declarations
//-----------------------------------------------------------------------------
class CRenderer : public CBaseVideoRenderer
{
public:
    CRenderer(CVideoCamera *pPres, LPUNKNOWN pUnk,HRESULT *phr);
    ~CRenderer();

public:
    HRESULT CheckMediaType(const CMediaType *pmt );     // Format acceptable?
    HRESULT SetMediaType(const CMediaType *pmt );       // Video format notification
    HRESULT DoRenderSample(IMediaSample *pMediaSample); // New video sample

private:
    CVideoCamera* m_pCP;// Pointer to Video capture object
    LONG m_lVidWidth;   // Video width
    LONG m_lVidHeight;  // Video Height
    LONG m_lVidPitch;   // Video Pitch
};


