// File DIALOGS.CPP

// Implement the modeless dialog to adjust the settings of the Chroma-Key
// system. 

#define _WIN32_DCOM 

#include "video.h"
#include "resource.h"
#include "resrc1.h"

int  red_break=0,        // These settings determine the colour threshold of the RGB components
     green_break=0,      // for switching the outpur from the background movie to the camera.
     blue_break=0;       // They are compared with the the VIDEO camera pixel colour values.
int  snap_band=10;       // Tolerence of difference band in snapshot mode
BOOL red_above=TRUE,     // The thresholds above can either be used as a switch, with the switch
     green_above=TRUE,   // acting on to values above the threshold or below it according 
     blue_above=TRUE;    // to these settings.
BOOL use_colour=TRUE;    // Use the colour key method of chroma-key

BOOL rgb_invert=FALSE;   // Invert the logical expression.
BOOL bIntegrate=FALSE;   // Integrate the snapshot over a few frames 

char iniFilename[]="vfx-chroma.ini";  // So that the settings can be saved use an INI file

extern               HWND ghWndDialog;
extern unsigned char *ScreenL;
extern unsigned char *ScreenS;
extern long           X,Y;
extern BOOL           bIntegrating;

static void TakeSnapshot(void);
 
static BOOL CALLBACK DlgProc(HWND hdlg,UINT msg,
                                   WPARAM wparam,LPARAM lparam){
 switch( msg ) {
   case WM_INITDIALOG:
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER1),
       TBM_SETRANGE,(WPARAM)TRUE,(LPARAM)MAKELONG(0,256));
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER1),
       TBM_SETPOS,TRUE,(LPARAM)red_break);
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER2),
       TBM_SETRANGE,(WPARAM)TRUE,(LPARAM)MAKELONG(0,256));
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER2),
       TBM_SETPOS,TRUE,(LPARAM)green_break);
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER3),
       TBM_SETRANGE,(WPARAM)TRUE,(LPARAM)MAKELONG(0,256));
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER3),
       TBM_SETPOS,TRUE,(LPARAM)blue_break);
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER4),
       TBM_SETRANGE,(WPARAM)TRUE,(LPARAM)MAKELONG(0,128));
     SendMessage(GetDlgItem(hdlg,IDC_SLIDER4),
       TBM_SETPOS,TRUE,(LPARAM)snap_band);
     SendDlgItemMessage(hdlg,IDC_RADIO1,BM_SETCHECK,red_above,0);
     SendDlgItemMessage(hdlg,IDC_RADIO2,BM_SETCHECK,!red_above,0);
     SendDlgItemMessage(hdlg,IDC_RADIO3,BM_SETCHECK,green_above,0);
     SendDlgItemMessage(hdlg,IDC_RADIO4,BM_SETCHECK,!green_above,0);
     SendDlgItemMessage(hdlg,IDC_RADIO5,BM_SETCHECK,blue_above,0);
     SendDlgItemMessage(hdlg,IDC_RADIO6,BM_SETCHECK,!blue_above,0);
     SendDlgItemMessage(hdlg,IDC_COLOUR,BM_SETCHECK,use_colour,0);
     SendDlgItemMessage(hdlg,IDC_SNAPSHOT,BM_SETCHECK,!use_colour,0);
     SendDlgItemMessage(hdlg,IDC_CHECK1,BM_SETCHECK,rgb_invert,0);
     SendDlgItemMessage(hdlg,IDC_INTEGRATE,BM_SETCHECK,bIntegrate,0);
     return (TRUE);
   case WM_HSCROLL:
     if((HWND)lparam == GetDlgItem(hdlg,IDC_SLIDER1)){
       switch (LOWORD(wparam)) {
         case SB_THUMBTRACK:
         case SB_THUMBPOSITION:
            red_break=SendMessage(GetDlgItem(hdlg,IDC_SLIDER1),TBM_GETPOS,0,0);
            break;
         default: break;
       }
       SendMessage(GetDlgItem(hdlg,IDC_SLIDER1),TBM_SETPOS,TRUE,(LPARAM)red_break);
     }
     else if((HWND)lparam == GetDlgItem(hdlg,IDC_SLIDER2)){
       switch (LOWORD(wparam)) {
         case SB_THUMBTRACK:
         case SB_THUMBPOSITION:
            green_break=SendMessage(GetDlgItem(hdlg,IDC_SLIDER2),TBM_GETPOS,0,0);
            break;
         default: break;
       }
       SendMessage(GetDlgItem(hdlg,IDC_SLIDER2),TBM_SETPOS,TRUE,(LPARAM)green_break);
     }
     else if((HWND)lparam == GetDlgItem(hdlg,IDC_SLIDER3)){
       switch (LOWORD(wparam)) {
         case SB_THUMBTRACK:
         case SB_THUMBPOSITION:
            blue_break=SendMessage(GetDlgItem(hdlg,IDC_SLIDER3),TBM_GETPOS,0,0);
            break;
         default: break;
       }
       SendMessage(GetDlgItem(hdlg,IDC_SLIDER3),TBM_SETPOS,TRUE,(LPARAM)blue_break);
     }
     else if((HWND)lparam == GetDlgItem(hdlg,IDC_SLIDER4)){
       switch (LOWORD(wparam)) {
         case SB_THUMBTRACK:
         case SB_THUMBPOSITION:
            snap_band=SendMessage(GetDlgItem(hdlg,IDC_SLIDER4),TBM_GETPOS,0,0);
            break;
         default: break;
       }
       SendMessage(GetDlgItem(hdlg,IDC_SLIDER4),TBM_SETPOS,TRUE,(LPARAM)snap_band);
     }
     break;
   case WM_COMMAND:
      switch(LOWORD(wparam)){
        case IDC_RADIO1: red_above=TRUE;    break;
        case IDC_RADIO2: red_above=FALSE;   break;
        case IDC_RADIO3: green_above=TRUE;  break;
        case IDC_RADIO4: green_above=FALSE; break;
        case IDC_RADIO5: blue_above=TRUE;   break;
        case IDC_RADIO6: blue_above=FALSE;  break;
        case IDC_COLOUR: use_colour=TRUE;   break;
        case IDC_SNAPSHOT: use_colour=FALSE;break;
        case IDC_CHECK1: rgb_invert ^=1;    break;
        case IDC_INTEGRATE: bIntegrate ^=1; break;
        case IDC_TAKE_SNAPSHOT:
          TakeSnapshot();          
          break;
        case IDC_QUIT:
          PostMessage(GetParent(hdlg),WM_DESTROY,0,0);
          break;
        default:
          break;
      }
   default: break;
 }
 return(FALSE);
}

void LoadPreferences(void){  // Load values from INI file.
 long i;
 red_break=GetPrivateProfileInt("VFX-INI","RED_BREAK",red_break,iniFilename);
 green_break=GetPrivateProfileInt("VFX-INI","GREEN_BREAK",green_break,iniFilename);
 blue_break=GetPrivateProfileInt("VFX-INI","BLUE_BREAK",blue_break,iniFilename);
 snap_band=GetPrivateProfileInt("VFX-INI","SNAP_BAND",snap_band,iniFilename);
 red_above=(BOOL)GetPrivateProfileInt("VFX-INI","RED_ABOVE",(int)red_above,iniFilename);
 green_above=(BOOL)GetPrivateProfileInt("VFX-INI","GREEN_ABOVE",(int)green_above,iniFilename);
 blue_above=(BOOL)GetPrivateProfileInt("VFX-INI","BLUE_ABOVE",(int)blue_above,iniFilename);
 rgb_invert=(BOOL)GetPrivateProfileInt("VFX-INI","RGB_INVERT",(int)rgb_invert,iniFilename);
 return;
}

void SavePreferences(void){  // Save values to INI file.
 char str[16];
 sprintf(str,"%ld",red_break);
 WritePrivateProfileString("VFX-INI","RED_BREAK",str,iniFilename);
 sprintf(str,"%ld",green_break);
 WritePrivateProfileString("VFX-INI","GREEN_BREAK",str,iniFilename);
 sprintf(str,"%ld",blue_break);
 WritePrivateProfileString("VFX-INI","BLUE_BREAK",str,iniFilename);
 sprintf(str,"%ld",(int)snap_band);
 WritePrivateProfileString("VFX-INI","SNAP_BAND",str,iniFilename);
 sprintf(str,"%ld",(int)red_above);
 WritePrivateProfileString("VFX-INI","RED_ABOVE",str,iniFilename);
 sprintf(str,"%ld",(int)green_above);
 WritePrivateProfileString("VFX-INI","GREEN_ABOVE",str,iniFilename);
 sprintf(str,"%ld",(int)blue_above);
 WritePrivateProfileString("VFX-INI","BLUE_ABOVE",str,iniFilename);
 sprintf(str,"%ld",(int)rgb_invert);
 WritePrivateProfileString("VFX-INI","RGB_INVERT",str,iniFilename);
 return;
}

static void TakeSnapshot(void){
  if(ScreenL != NULL && ScreenS != NULL && X > 0 && Y > 0){
    memcpy(ScreenS,ScreenL,X*Y*3);
    if(bIntegrate)bIntegrating=TRUE; // Timer will integrate over a few frame!
  }   
}

BOOL DoDialog(HINSTANCE hInstance, HWND hWnd){
 LoadPreferences();
 ghWndDialog=CreateDialog(hInstance,MAKEINTRESOURCE(IDD_DIALOG1),
                          hWnd,(DLGPROC)DlgProc);
 ShowWindow(ghWndDialog,SW_SHOW);
 return TRUE;
}

void QuitDialog(void){
  if(IsWindow(ghWndDialog))DestroyWindow(ghWndDialog);
  SavePreferences();
}