// File: avirender.h


// Define the class for the custom renderer filter that we use in the FiltgerGraph
// that is rendering the video from the AVI movie file into the RAM buffers.

// The class replicates the CRenderer class for a DirectShow Renderer filter except
// that it renders an AVI file into a RAM buffer.


struct __declspec(uuid("{509DDDBE-8C68-4f3e-A9F8-16866373EF91}")) CLSID_AviRenderer;


//-----------------------------------------------------------------------------
// CTextureRenderer Class Declarations
//-----------------------------------------------------------------------------
class CAviRenderer : public CBaseVideoRenderer
{
public:
    CAviRenderer(CAviPlay *pPres, LPUNKNOWN pUnk,HRESULT *phr);
    ~CAviRenderer();

public:
    HRESULT CheckMediaType(const CMediaType *pmt );     // Format acceptable?
    HRESULT SetMediaType(const CMediaType *pmt );       // Video format notification
    HRESULT DoRenderSample(IMediaSample *pMediaSample); // New video sample

private:
    CAviPlay * m_pCP;   // Pointer to the AVI file renderer object.
    LONG m_lVidWidth;   // Video width
    LONG m_lVidHeight;  // Video Height
    LONG m_lVidPitch;   // Video Pitch
};


