// File AviRenderer.cpp

// Implements the custom built renderer filter in the FilterGraph that 
// sends the output of the AVI display to the memory buffer, pointed to
// by ScreenAVI.

#include "AviPlay.h"
#include "AviRenderer.h"
#include "classes.h"

#define X__Malloc(s)    LocalAlloc(LMEM_FIXED,s)
#define X__Free(p)      LocalFree((HLOCAL)p)

extern void Msg(TCHAR *szFormat, ...);

extern unsigned char           *ScreenAVI;  // AVI movie frame 24 bit RAM buffer
extern long                     Xavi,Yavi;  // Movie width and height

CAviRenderer::CAviRenderer(CAviPlay *pPres,
								   LPUNKNOWN pUnk, 
								   HRESULT *phr )
                                  : CBaseVideoRenderer(__uuidof(CLSID_AviRenderer), 
                                    NAME("Avi Renderer"), pUnk, phr)
                                  , m_pCP( pPres){  // Pointer to the movie object
    // Store and AddRef the texture for our use.
    ASSERT(phr);
    if (phr){
        if( !pPres ){
            *phr = E_INVALIDARG;
        }
        else {
            *phr = S_OK;
        }
    }
}

CAviRenderer::~CAviRenderer(){
    // Do nothing
}

HRESULT CAviRenderer::CheckMediaType(const CMediaType *pmt){
	// olny allows RGB video sample formats
    HRESULT   hr = E_FAIL;
    VIDEOINFO *pvi=0; 
    CheckPointer(pmt,E_POINTER);
    ASSERT( m_pCP);
    try    {
        // Reject the connection if this is not a video type
        if( *pmt->FormatType() != FORMAT_VideoInfo )  {
            return E_INVALIDARG;
        }
        pvi = (VIDEOINFO *)pmt->Format();
        if( IsEqualGUID( *pmt->Type(), MEDIATYPE_Video) )        {
            hr = S_OK;
            if( IsEqualGUID( *pmt->Subtype(), MEDIASUBTYPE_RGB24) ){
            }
            else{
                hr = DDERR_INVALIDPIXELFORMAT;
            }
        }
        if( FAILED(hr)){
            return hr;
        }        
    }// try
    catch(...){
        Msg(TEXT("Failed to check media type in the renderer. Unhandled exception hr=0x%x"), E_UNEXPECTED);
        hr = E_UNEXPECTED;
    }   
    return hr;
}

HRESULT CAviRenderer::SetMediaType(const CMediaType *pmt){
    HRESULT hr = S_OK;
    VIDEOINFO *pviBmp = NULL;   // Bitmap info header
	unsigned char *S;
    try{
        // Retreive the size of this media type
        pviBmp = (VIDEOINFO *)pmt->Format();
        Xavi = m_lVidWidth  = pviBmp->bmiHeader.biWidth;
        Yavi = m_lVidHeight = abs(pviBmp->bmiHeader.biHeight);
        m_lVidPitch  = (m_lVidWidth * 3 + 3) & ~(3); // We are forcing RGB24
        // Create the RAM buffer for the AVI movie frame.
        // This is called ONCE for each execution of the FilterGraph         
        if(ScreenAVI != NULL)X__Free(ScreenAVI); ScreenAVI=NULL;
        if((ScreenAVI = (unsigned char *)X__Malloc(3*Xavi*Yavi)) == NULL){
            hr = E_UNEXPECTED;
		    return hr;
		}
        HWND glWindow=FindWindow(CLASSNAME1,NULL);
        if(glWindow != NULL)PostMessage(glWindow,(WM_USER+1),100,0); 
	}// try
    catch(...) {
        Msg(TEXT("Failed to set media type in the renderer. Unhandled exception hr=0x%x"), E_UNEXPECTED);
        return hr;
    }
    return hr;
}


HRESULT CAviRenderer::DoRenderSample( IMediaSample * pSample ){
    HRESULT hr = S_OK;
    try { // Copy the media sample to the the AVI ram buffer - call through to the movie object to do it.
      hr = m_pCP->CopyMediaSample( pSample, m_lVidPitch );
    }
    catch(...)    {
    }
    return hr;
}
