// File: aviplay.h

// Defines an object class that will handle the presentation of an AVI file
// into a RAM buffer.  An object of this class is created when we open an AVI
// file to play in the background of the keyed video source.

#include <windows.h>
#include <mmsystem.h>
#include <atlbase.h>
#include <stdio.h>
#include <Streams.h>
#include <dshow.h>
#include <commctrl.h>
#include<process.h>
#include <gl\gl.h>
#include <gl\glu.h>

class CAviPlay {
public:
    CAviPlay( );
    ~CAviPlay();
    HRESULT CopyMediaSample( IMediaSample *pSample, LONG lSamplePitch);
    void Cleanup(void);
    HRESULT InitAviPlay();
    void CheckMovieStatus(void);
private:
    // methods
    HRESULT BuildMovieGraph(IBaseFilter *pRenderer);
    // data
    CComPtr<ICaptureGraphBuilder2>  m_pCapture;     // Helps to render capture graphs
    CComPtr<IGraphBuilder>          m_pGB;          // GraphBuilder
    CComPtr<IMediaControl>          m_pMC;          // Media Control
    CComPtr<IMediaEvent>            m_pME;          // Media Event
    CComPtr<IMediaSeeking>          m_pMS;          // Media Seeking
    CComPtr<IMediaPosition>         m_pMP;          // Media Position
    CComPtr<IMediaFilter>           m_pMF;          // Media Filter

};

